package demo.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

/**
 * 
 * @author MAbernethy
 */
public class JCoolButton extends JButton
{	
	private boolean mouseOver;
	
	public JCoolButton()
	{
		super();
		init();
	}
	
	private void init()
	{
		setBorderPainted(false);
		addMouseListener(new MouseAdapter()
		{	
			public void mouseEntered(MouseEvent arg0)
			{
				mouseOver = true;
				setBorderPainted(true);
			}

			public void mouseExited(MouseEvent arg0)
			{
				mouseOver = false;
				setBorderPainted(false);
			}
		}
		);
	}
	
	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		if (!mouseOver)
		{
			g.setColor(getParent().getBackground());
			g.fillRect(0,0,getSize().width, getSize().height);	
			g.setColor(getForeground());
			int width = SwingUtilities.computeStringWidth(getFontMetrics(getFont()), getText());
			int height = getFontMetrics(getFont()).getHeight();
			g.drawString(getText(), getWidth()/2 - width/2, getHeight()/2 + height/2);	
		}
	}

	
	public JCoolButton(String text)
	{
		super(text);
		init();
	}
	
	public JCoolButton(Action a)
	{
		super(a);
		init();
	}
	
	public JCoolButton(Icon i)
	{
		super(i);
		init();
	}
	
	public JCoolButton(String text, Icon i)
	{
		super(text, i);
		init();
	}
}
