/*<fcopy>
   <copyright year = 2004-2005>
      <company = 'Gentee, Inc.'  url = 'http://www.gentee.com'  email = info@gentee.com >
      <author = 'Alexey Krivonogov'>
      <file>
This file is part of the Gentee STDLIB library (Linux version).
      </>
   </>
   <desc>
   </>
</>*/

define <export> {
   //    copyfiles
   COPYF_RO        = 0x0100    //   read-only 
   COPYF_SAVEPATH  = 0x0200    //   
   COPYF_ASK       = 0x0400    //   
   
   // mode  copyfiles   
   COPY_OVER      = 0         //  
   COPY_SKIP                  // 
   COPY_NEWER                 //   
   COPY_MODIFIED              //   
   
   //    process 
   COPYN_FOUND    = 1         //    
   COPYN_NEWDIR               //  
   COPYN_ERRDIR               //   
   COPYN_ASK                  //   
   COPYN_ERRFILE              //   
   COPYN_NEWFILE              //   
   COPYN_BEGIN                //  
   COPYN_PROCESS              //  
   COPYN_END                  //  
   COPYN_ERRWRITE             //   

   //    process 
   COPYR_NOTHING  = 0         //   
   COPYR_BREAK                //  
   COPYR_RETRY                //  
   COPYR_SKIP                 //   
   COPYR_OVER                 //  
   COPYR_OVERALL              //    
   COPYR_SKIPALL              //   
}

func  uint isequalfiles( str left right )
{
   uint  hleft hright lsize result temp size
   buf   lbuf rbuf
   
   hleft = open( left, $OP_READONLY )
   if !hleft : return 0
   lsize = getfilesize( left )
   hright = open( right, $OP_READONLY )
   size = 0x8000
   if hright && lsize == getfilesize( right )
   {
      while lsize
      {
         temp = min( lsize, size )//300000 )
         lbuf.use = 0
         rbuf.use = 0
         read( hleft, lbuf, temp )
         read( hright, rbuf, temp )
         if mcmp( lbuf.ptr(), rbuf.ptr(), temp ) : break
         lsize -= temp
         size = 0x80000
      }
      if !lsize : result = 1
   }
   close( hleft )
   close( hright )
   return result
}

func uint copyfiles( str src dir, uint flag mode, uint process )
{
   uint     notifyret

   subfunc uint notify( uint code, uint left right )
   {
      if process : notifyret = process->func( code, left, right )
      return notifyret
   }

   ffind  fd
   str    destname srcdir temp
   arr    dirs of str
   uint   i

   src.ffullname( src )
   dir.ffullname( dir )
   srcdir.fgetdir( src )

   fd.init( src, flag )

   foreach finfo cur, fd
   {
      if flag & $COPYF_SAVEPATH : temp.copy( cur.fullname.ptr() + *srcdir + 1 )
      else : temp = cur.name
      ( destname = dir ).faddname( temp )

      if notify( $COPYN_FOUND, &cur, &destname ) == $COPYR_SKIP : continue

      if ( cur.attrib & 0xF000 ) == 0x4000 /*LU cur.attrib & $FILE_ATTRIBUTE_DIRECTORY LU*/ : temp = destname
      else : temp.fgetdir( destname )
      label dirretry
      if !verifypath( temp, dirs )
      {
         notify( $COPYN_ERRDIR, &dirs[*dirs - 1], 0 )
         if notifyret == $COPYR_RETRY : goto dirretry
         if notifyret == $COPYR_BREAK : return 0
      }

      foreach str ndir, dirs : notify( $COPYN_NEWDIR, &ndir, 0 )

      if ( cur.attrib & 0xF000 ) == 0x4000 /*LU cur.attrib & $FILE_ATTRIBUTE_DIRECTORY LU*/
      {
         ( temp = cur.fullname ).faddname( "*.*" )
         copyfiles( temp, destname, flag | $FIND_RECURSE, mode, process )
      }
      else
      {
         uint noexist

         if fileexist( destname )
         {
            finfo fi

            if mode == $COPY_SKIP : continue
            getfileinfo( destname, fi )
            if mode == $COPY_NEWER &&
                /*LU CompareFileTime( cur.lastwrite, fi.lastwrite ) <= 0 LU*/
					 cur.lastwrite <= fi.lastwrite
            {
               continue
            }
            if mode == $COPY_MODIFIED && fi.sizelo == cur.sizelo &&
               isequalfiles( cur.fullname, destname )
            {
               continue
            }
            if flag & $COPYF_ASK
            {
               notify( $COPYN_ASK, &cur, &fi )
               switch notifyret
               {
                  case $COPYR_BREAK : return 0
                  case $COPYR_SKIP : continue
                  case $COPYR_OVERALL : flag &= ~$COPYF_ASK
                  case $COPYR_SKIPALL
                  {
                     mode = $COPY_SKIP
                     continue
                  }
               }
            }
            /*LU if flag & $COPYF_RO  && fi.attrib & $FILE_ATTRIBUTE_READONLY LU
            {
               setattribnormal( destname )
            }LU*/
         }
         else : noexist = 1

         uint  hsrc hdest size icopy
         buf   cbuf

         label fileretry
			fstat st
			utime ut

			if _stat( cur.fullname.ptr(), &st ) : return 0
			hsrc = open( cur.fullname, $OP_READONLY )
         if !hsrc
         {
            switch notify( $COPYN_ERRFILE, &cur.fullname, 0 )
            {
               case $COPYR_BREAK : return 0
               case $COPYR_RETRY : goto fileretry
               case $COPYR_SKIP : continue
            }
         }
         hdest = open( destname, $OP_CREATE )
         if !hdest
         {
            close( hsrc )
            switch notify( $COPYN_ERRFILE, &destname, 0 )
            {
               case $COPYR_BREAK : return 0
               case $COPYR_RETRY : goto fileretry
               case $COPYR_SKIP : continue
            }
         }

         if noexist : notify( $COPYN_NEWFILE, &destname, 0 )

         notify( $COPYN_BEGIN, &cur, &destname )
         size = cur.sizelo

         uint copied = 0
         while size
         {
            icopy = min( size, 0x80000 )//300000 )
            cbuf.use = 0
            read( hsrc, cbuf, icopy )
            label writeretry
            if !write( hdest, cbuf )
            {
               switch notify( $COPYN_ERRWRITE, &destname, 0 )
               {
                  case $COPYR_BREAK : return 0
                  case $COPYR_RETRY : goto writeretry
                  case $COPYR_SKIP : break
               }
            }
            notify( $COPYN_PROCESS, &destname,
                     ( copied += icopy ) * 100 / cur.sizelo )
            size -= icopy
         }
         /*LU SetFileTime( hdest, 0->filetime, 0->filetime, cur.lastwrite ) LU*/
         close( hdest )
         close( hsrc )
         /*LU setfileattrib( destname, cur.attrib ) LU*/
			ut.acttime = st.st_atime
         ut.modtime = st.st_mtime
         
         _chmod( destname.ptr(), st.st_mode )
			_chown( destname.ptr(), st.st_uid, st.st_gid )
         _utime( destname.ptr(), &ut )   		
         notify( $COPYN_END, &cur, &destname )
      }
   }
   return 1
}

func uint defcopyproc( uint code left right )
{
   switch code
   {
/*      case $COPYN_FOUND {
         print("FOUND = \( left->finfo.fullname ) to \( right->str )\n")
      }
      case $COPYN_NEWDIR {
         print("NEWDIR = \( left->str )\n")
      }
      case $COPYN_NEWFILE {
         print("NEWFILE = \( left->str )\n")
      }*/      
      case $COPYN_BEGIN {
         print("Copying \( right->str )  0%\r")
      }
      case $COPYN_PROCESS {
         print("Copying \( left->str ) \( right )%\r")
      }
      case $COPYN_END {
         print("Copied  \( right->str ) 100%\n")
      }
      case $COPYN_ERRDIR {
         return ?( conrequest("Cannot create a directory \( left->str )!
Abort [A] | Retry [R] : ", "Aa|Rr" ), $COPYR_RETRY, $COPYR_BREAK )
      }
      case $COPYN_ASK {
         str  edate etime
         str  ndate ntime
         uint ret

         getfiledatetime( right->finfo.lastwrite, edate, etime )
         getfiledatetime( left->finfo.lastwrite, ndate, ntime )
      
         ret = conrequest("File already exists
Existing File: \( right->finfo.fullname )
Size: \( right->finfo.sizelo ) Date: \(edate) Time: \(etime)
     New File: \( left->finfo.fullname )
Size: \( left->finfo.sizelo ) Date: \(ndate) Time: \(ntime)

Overwrite [O] | Skip [S] | Overwrite All [V] | Skip All [K] | Abort [A] : ",
"Oo|Ss|Vv|Kk|Aa" )
         switch ret 
         {
            case 0 : return $COPYR_OVER
            case 1 : return $COPYR_SKIP
            case 2 : return $COPYR_OVERALL
            case 3 : return $COPYR_SKIPALL
            case 4 : return $COPYR_BREAK
         }
      }
      case $COPYN_ERRFILE, $COPYN_ERRWRITE {
         switch conrequest( "Cannot \( ?( code == $COPYN_ERRFILE,"open/create a file","write to a file" )) \( left->str )!
Abort [A] | Retry [R] | Skip [S]: ", "Aa|Rr|Ss" )
         {
            case 0: return $COPYR_BREAK
            case 1: return $COPYR_RETRY
            case 2: return $COPYR_SKIP
         }
      }
   }
   return 0
}
