/*<stack>
   <copyright year = 2004-2005>
      <company = 'Gentee, Inc.'  url = 'http://www.gentee.com'  email = info@gentee.com >
      <author = 'Alexey Krivonogov'>
      <file>
This file is part of the Gentee STDLIB library.
      </>
   </>
   <desc>
   </>
</>*/


type stack {
   arr   sarr  
}

operator uint *( stack left )
{
   return *left.sarr
}

method uint stack.index( uint i )
{
   return this.sarr.index( i )
}

method uint stack.push
{
   this.sarr.expand( 1 )
   return this.index( *this - 1 )
}

method uint stack.push( uint val )
{
   uint ind
   
   ind = this.sarr.expand( 1 ) - 1
   this.index( ind )->uint = val 
   
   return val
}

method str stack.push( str val )
{
   uint ptr = this.push()
   
   ptr->str = val
   
   return ptr->str
}

method uint stack.pop
{
   uint count = *this
   
   if count
   {
      count--
      if type_hasdel( this.sarr.itype )
      {
         type_delete( this.index( count ), this.sarr.itype )
      }       
      this.sarr.abuf.use -= this.sarr.isize         
   }
   return ?( count, this.index( count - 1 ), 0 )
}

method uint stack.top
{
   return ?( *this, this.index( *this - 1 ), 0 )
}

method uint stack.popval
{
   uint count = *this
 
   if !count : return 0
   
   uint ret = this.index( count - 1 )->uint
   this.pop()
   
   return ret
}

method str stack.pop( str val )
{
   uint count = *this
 
   if !count : return val

   val = this.index( count - 1 )->str
   this.pop()
   
   return val
}

//        
method stack.oftype( uint itype )
{
   this.sarr.oftype( itype )
}

method stack.clear
{
   this.sarr.delete()
   this.sarr.abuf.use = 0
}
